'Get parameters
' + As defined in menu.con, editor42 will send the following
' + levelname levelPath gamePath and toolPath

levelName=wscript.arguments(0)
levelPath=wscript.arguments(1)
gamePath=wscript.arguments(2)
toolPath=wscript.arguments(3)
modName=""


' Open levelinfo.txt file for mod name stored with the other script
set fso=CreateObject("Scripting.FileSystemObject")
set file=fso.OpenTextFile(cpath(levelPath&"\levelinfo.txt"))
if file is nothing then
	' If the file does not exist, throw an error message
	noModName
end if

' Read lines from file
do while not file.atEndOfStream
	line=file.readline
	if len(line)>0 then
		tokens=split(line,"=")
		' parse the line
		if lcase(tokens(0))="modname" then
			'If the token name is modname, then this is the mod name
			modName=tokens(1)
		end if
	end if
loop



' Check if the modname is valid, else throw a message
if len(modName)=0 then
	noModName
end if


' Now we must make sure the mod and levels directory does exist
if not fso.folderExists(cpath(gamePath& "\mods\" &modName)) then
	fso.createFolder(cpath(gamePath& "\mods\" &modName))
end if
if not fso.folderExists(cpath(gamePath& "\mods\" &modName& "\Archives")) then
	fso.createFolder(cpath(gamePath& "\mods\" &modName& "\Archives"))
end if
if not fso.folderExists(cpath(gamePath& "\mods\" &modName& "\Archives\bf1942")) then
	fso.createFolder(cpath(gamePath& "\mods\" &modName& "\Archives\bf1942"))
end if
if not fso.folderExists(cpath(gamePath& "\mods\" &modName& "\Archives\bf1942\levels")) then
	fso.createFolder(cpath(gamePath& "\mods\" &modName& "\Archives\bf1942\levels"))
end if


set shell = WScript.CreateObject("WScript.Shell")

' Execute makerfa
set exec=shell.exec(cpath(toolPath& "\makerfa\makerfa.exe"))

' Send parameters
exec.stdin.writeline cpath(levelPath)
exec.stdin.writeline "bf1942/levels/" &levelName& "/"
exec.stdin.writeline "n"
exec.stdin.writeline cpath(gamePath& "\mods\" &modName& "\Archives\bf1942\levels\" &levelName&".rfa")
exec.stdin.writeline "n"
exec.stdin.writeline

'Read the last line
do while not exec.stdout.atendofstream
	str=exec.stdout.readline
loop

'And display it
wscript.echo str



function noModName
	wscript.echo "Mod name not specified for this level."&vbNewline&"Specify a mod name using Tools->RFA packing->Specify Mod Name"
	wscript.quit 1
end function

function cpath(byval str)
	str=replace(str,"/","\")
	cpath=replace(str,"\\","\")
end function