--
-- TODO
-- 

global projectPath = "c://tmpmax//"
global pconINI =  projectPath + "pcon-max.ini"
global pconPath = projectPath + "pcon"
global unit_scale = 10

global aboutRoll()

rollout NedtoolGUI "BF1942 .con object importer v.010" width:280 height:205
(

	-- file def
	editText filePath "Object" pos:[17,24] width:202 height:16
	button browseBut "Browse" pos:[224,24] width:45 height:16 tooltip:"Locate a .con file"

	-- main buttons
	button importConBut "Import Con file" pos:[5,184] width:90 height:19 tooltip:"Create helper objects from a .con file"
	button clearConBut  "Clear Con objects" pos:[100,184] width:90 height:19 tooltip:"Clean up the helper objects"
	button aboutBut "About" pos:[195,184] width:80 height:19 tooltip:"What the?!!?"
	-- button extBut "Exit" pos:[165,145] width:110 height:19 tooltip:"enough of this ..."

	-- options	
 	checkbox flag_show_entrypoint  "Show Entry Radius" pos:[17,82] width:202 height:19 
	checkbox flag_hide_extra  "Hide Wreck and Simple meshes" pos:[17,107] width:202 height:19 
	checkbox flag_import_geo  "Import Geometries" pos:[17,132] width:202 height:19 

	-- import geo path
	editText geoPath ".sm folder" pos:[34,153] width:184 height:16
	button browseButGeo "Browse" pos:[224,153] width:45 height:16 tooltip:"Locate .sm folder"


	-- groupings
	groupBox grpTool ".CON file path" pos:[6,4] width:269 height:50
	groupBox grpOpt "Options" pos:[6,62] width:269 height:115



---------------------------------------
-- From Rexman's Tools
---------------------------------------

-- string to boolean 
fn str2bool testN =
(if testN[1] == "t" then true;else false)

-- string to lower case
fn lowerCase instring =
(  local upper, lower, outstring
   upper="ABCDEFGHIJKLMNOPQRSTUVWXYZ"
   lower="abcdefghijklmnopqrstuvwxyz"
   outstring=copy instring

   for i=1 to outstring.count do
   (  j=findString upper outstring[i]
      if (j != undefined) do outstring[i]=lower[j]
   )
   outstring
)

--- the meat
fn readSMVisMesh thisFile Dascale option1 showTex justTopLod=
(
	f = fopen thisFile "rb"
	SM_HeaderV = (Readlong f #unsigned)
	finalMesh = undefined
	with redraw off
	if SM_HeaderV <= 10 then
	(

		fseek f 28 #seek_cur
		if SM_HeaderV == 10 do
			fseek f 1 #seek_cur
		numTopModels = (Readlong f #unsigned)
		for i=1 to numTopModels do -- hitbox skip
		(	tmpSeek = (Readlong f #unsigned)
			fseek f tmpSeek #seek_cur
		)
	
		numLodMeshes = Readlong f #unsigned
			if showTex do print ( "numLodMeshes: " + (numLodMeshes as string) ) 
		
		numLodMeshesExport = numLodMeshes
		if justTopLod do numLodMeshesExport = 1
		
		for a=1 to numLodMeshesExport do
		( 
			numMaterials = (Readlong f #unsigned)
				if showTex do print ( "  numMaterials: " + (numMaterials as string) )
			
			matName = #()
			VtypeID = #()
			VertByteSize = #()
			numVerts = #()
			numFaces = #()
			for i=1 to numMaterials do
			(	nameLn = (Readlong f #unsigned)
				matName[i] = readString f
					
				fseek f 15 #seek_cur
				VtypeID[i] = (Readlong f #unsigned)
				VertByteSize[i] = (Readlong f #unsigned)
					if showTex do print ( "   " + (i as string) + "_matName: " + (matName[i] as string) + "\n" + "    VtypeID: " + (VtypeID[i] as string) + "\tVertByteSize: " + (VertByteSize[i] as string) )
				numVerts[i] = (Readlong f #unsigned)
				numFaces[i] = (Readlong f #unsigned)
	
				fseek f 4 #seek_cur
			)
			b = #()
			for n=1 to numMaterials do
			(
				realVerts = #()
				Vnormal = #()
				Tverts = #()
				lightmapVerts = #()
				for i=1 to numVerts[n] do
				(
					realVerts[i] = [0,0,0]
					realVerts[i].x = (readfloat f)*Dascale
					realVerts[i].z = (readfloat f)*Dascale
					realVerts[i].y = (readfloat f)*Dascale
					
					Vnormal[i] = [0,0,0]
					Vnormal[i].x = (readfloat f)
					Vnormal[i].z = (readfloat f)
					Vnormal[i].y = (readfloat f)
					
					if VertByteSize[n] == 32 then
					(
						Tverts[i] = [0,0,0]
						Tverts[i].x = readfloat f
						Tverts[i].y = (-(readfloat f) + 1.0)
					)
					else  
					(	if VertByteSize[n] == 40 then
						(
							Tverts[i] = [0,0,0]
							Tverts[i].x = readfloat f
							Tverts[i].y = (-(readfloat f) + 1.0)
							
							lightmapVerts[i] = [0,0,0]
							lightmapVerts[i].x = readfloat f
							lightmapVerts[i].y = (-(readfloat f) + 1.0)
						)
						else
						(if showTex do print ("Unkown vertx byte cnt: " + (VertByteSize[n] as string ))
							fclose f
							return false
						)
					)				
				)
				facelist = #()
				for i=1 to (numFaces[n]/3) do
				(
					facelist[i] = [1,2,3]
					facelist[i].z = (readShort f)+1
					facelist[i].y = (readShort f)+1
					facelist[i].x = (readShort f)+1
				)
				--print ( " V: " + (realVerts as string) ); print ( "  F: " + (facelist as string) )
				
				tmpMatIDs = #()
				for i=1 to (numFaces[n]/3) do
					tmpMatIDs[i] = n 
					
				b[n] = mesh name:matName[n] vertices:realVerts faces:facelist materialIDS:tmpMatIDs
				
				meshop.setmapsupport b[n] 1 false
				setnumTverts b[n] (numVerts[n])
				buildTVfaces b[n] false
				for i=1 to (numFaces[n]/3) do
					setTVface b[n] i facelist[i]
	
				if (option1) and VertByteSize[n] == 40 then
				(
					for i=1 to (numVerts[n]) do
						setTVert b[n] i lightmapVerts[i]
				)
				else
				(
					for i=1 to (numVerts[n]) do
						setTVert b[n] i tverts[i]
				)
				
			)

			for i=2 to b.count do attach b[1] b[i]
			b[1].name = lowerCase(getFilenameFile thisFile)
			finalMesh = b[1]
		)
	)
	else (if showTex do print "ERROR: Unsupported file type")
	
	-- for i=1 to 8 do print (( getTvert finalMesh i) as string )

	-- ned addition
	select finalMesh
	
	fclose f
	if showTex do print "--Done--"
	return finalMesh
)

---------------------------------------
-- End Rex's Stuff
---------------------------------------


	
fn importCon fname  =
(
	print "Importing .con objects"

	-- sm path
	if geoPath.text != "" then (
		smPath = geoPath.text
		
		-- make sure last character is a backslash
		if smPath[smPath.count] != "//" then smPath = smPath + "//"
		
	) else (
		-- fall back on default if geoPath is empty
		smPath = projectPath + "standardmesh//"
	)

	-- execute perl pre-processor
	temp = pconPath + " \"" + fname + "\" \"" + projectPath + "\""
	-- format "execute: %\n" temp	
	DOSCommand (temp)

	

	confile = projectPath + "out.ccon"
	format "- confile: %\n" confile 	

	f = openfile confile
	if f == undefined then (
		print "Error: cound not find compiled con file "
		return 0
	)


	-- create wireframe material for entry radius
	if flag_show_entrypoint.checked == true then (
		meditMaterials[1].wire = on
	)

	object_ct = 0;

	while 1 > 0 do
	(
		-- get a line
		str = readline f
		if eof(f) then exit

		object_ct = object_ct + 1
	
		-- print str
	
		dd = filterstring str " "
	
		-- parse the line
		type = dd[1]
		name = dd[2]
		ee = filterstring dd[3] ";"
		special = dd[4]
	
		-- get position and rotation values
		pos = filterstring ee[1] "/"
		rot = filterstring ee[2] "/"			
		
		-- make the object
		case of 
		(
	    	(type == "EntryPoint" and flag_show_entrypoint.checked == true): (
				temp = (special as float) * unit_scale
				Sphere radius:temp smooth:on segs:24 chop:0 slice:off sliceFrom:0 sliceTo:0 isSelected:on				
				-- assign wireframe material
				$.material = meditMaterials[1]
		    	)
	    	(flag_import_geo.checked == true and special != undefined and type != "EntryPoint"): (
				temp = smPath + special + ".sm"
							
					if doesFileExist(temp) then (
						format "- importing %\n" temp
						
						-- fn readSMVisMesh thisFile Dascale option1 showTexT justTopLod=
						-- readSMVisMesh fname val32 (lightmapTxChck.checked) true (gonnaskip2last.checked)
						readSMVisMesh temp unit_scale false false true

					) else (
						format "- standard mesh % not found!\n" temp
						Sphere radius:1 smooth:on segs:24 chop:0 slice:off sliceFrom:0 sliceTo:0 isSelected:on
					)				
							
		    	)				
			default:
				Box lengthsegs:1 widthsegs:1 heightsegs:1 length:2 width:2 height:2 isSelected:on
		)		

		-- label it
		$.name = name
	
		-- move it 			
		xpos = (pos[1] as float) * unit_scale
		ypos = (pos[3] as float) * unit_scale
		zpos = (pos[2] as float) * unit_scale

		move $ [ xpos, ypos, zpos ] 
		
		-- rotate it
		xrot = -(rot[2] as float) 
		yrot = -(rot[3] as float)
		zrot = -(rot[1] as float)		
		
		rot_box = eulerangles  xrot yrot zrot
		rotate $ rot_box 
		
		if flag_hide_extra.checked == true  then ( 
			if matchPattern $.name pattern:"*Wreck" then 
				hide $
			if matchPattern $.name pattern:"*Simple" then 
				hide $
		)
	) 

	-- final
	-- format "Total objects = %\n" object_ct	
	
	-- clean it up 
	close f 

)

--
-- clearCon()
--
-- - deletes all objects that have a '__' prefix
fn clearCon = 
(
	-- exit if no objects exist
	if geometry.count <= 0 then 
		return 0
	
	
	format "Deleting .CON helper objects (total objects %)\n" geometry.count
	
	ct = 1

	-- loop through all objects
	do 	( 		-- all .CON helper objects start with the prefix '__'
		if matchPattern geometry[ct].name pattern:"__*" then
		(
			-- delete current object, array is automatically adjusted
			delete geometry[ct]
		) else ( 
			-- point to next object in the array
			ct = ct + 1
		)
		
	) while geometry[ct] != undefined
	
	format "- remaining objects: %\n" geometry.count

)


-- initialize		
on NedtoolGUI open do ( 

	if not doesFileExist(projectPath) then (
		temp = "The " + projectPath + " folder does not exist!\n\nPlease create it and then restart this script."
		MessageBox temp
	)
	
	if doesFileExist(pconINI) then (
		-- load previous settings
		filePath.text = GetINISetting pconINI "Main" "con_path" 
		geoPath.text = GetINISetting pconINI "Main" "geo_path" 
		flag_show_entrypoint.checked = str2bool (GetINISetting pconINI "Main" "entry_radius")
		flag_hide_extra.checked = str2bool (GetINISetting pconINI "Main" "hide_extra")
		flag_import_geo.checked = str2bool  (GetINISetting pconINI "Main" "import_geo" 	)
	) else (
		-- defaults
		filePath.text = ""
		geoPath.text = projectPath + "standardmesh//"
		flag_show_entrypoint.checked = false
		flag_hide_extra.checked = true
		flag_import_geo.checked = false
	)
) 

-- cleanup 
on NedtoolGUI close do ( 
	SetINISetting pconINI "Main" "con_path" filePath.text
	SetINISetting pconINI "Main" "geo_path" geoPath.text
	SetINISetting pconINI "Main" "entry_radius" (flag_show_entrypoint.checked as string)
	SetINISetting pconINI "Main" "hide_extra" (flag_hide_extra.checked as string)
	SetINISetting pconINI "Main" "import_geo"   (flag_import_geo.checked as string)
) 


	
	-- button presses
	
	on browseBut pressed do
	(
		temp = getOpenFileName caption:"Locate a vehicle .con file" types:" .con|*.con|"
		if temp != undefined then (
			filePath.text = temp
		)
	)
	on browseButGeo pressed do
	(
		temp = getOpenFileName caption:"Locate a 1942 Standard Mesh folder" types:" .sm|*.sm|"
		
		if temp != undefined then (		
			if getFilenameType(temp) == undefined then (
				geoPath.text = temp + "//"
			) else (
				geoPath.text = getFilenamePath(temp)
			)
		)
	)
		
	on importConBut pressed do
		importCon(filePath.text)

	on clearConBut pressed do
		clearCon()

	on aboutBut pressed do
		createDialog aboutRoll

	-- on exitBut pressed do
	--(
	--	end		
	--)


	
)

----------------------

Rollout aboutRoll "About"
(
	Group "BF1942 .con importer v.010"
	(
		label lab "by:  Neddy299"
		HyperLink webSiteNed "http://12.108.40.74/bf/" align:#center address:"http://12.108.40.74/bf/" color:(color 0 0 150) hoverColor:(color 150 0 0)
		label labb "mesh import code by Rexman" 
		HyperLink webSiteRex "http://www.rex3d.com/bf/" align:#center address:"http://www.rex3d.com/bf/" color:(color 0 0 150) hoverColor:(color 150 0 0)
	)
)

---------------------------------------

createDialog NedtoolGUI	
	
