

use pcon;

$version = "v.006";

$DEBUG = 1;

$file_path = "c:\\tmpmax";
$file_ccon = $file_path . "\\out.ccon";

print "Maxscript CON Compiler $version\n";


### init vars
$head_object = "";


### open file
if ($ARGV[0] eq "") {
	die "\n\tUsage $0 <con file>\n";
}

### over-ride default out folder
if ($ARGV[1] ne "") {
	print "- ARGV[1] = $ARGV[1]\n";
	$ARGV[1] =~ s/\"//g;
	if ($ARGV[1] =~ /\\$/) { 
		# strip trailing slash if it exists
		chop ($ARGV[1]); 
	}
	print "- ARGV[1] = $ARGV[1]\n";	
	$file_ccon = $ARGV[1] . "\\out.ccon";	
}


### get the path from the command line

if ($ARGV[0] =~ /\.con$/) {
	### con file was given, strip file name off full path

	@splitpath = split (/\\/, $ARGV[0]);
	pop @splitpath;
	$path = join('\\', @splitpath);
} else {
	$path = $ARGV[0];
}

print "- path: $path\n";


### get all .con files in the dir
opendir (DIR, $path);


### make sure that we process the files in a specific order geometries, objects, and then the rest
$file_geo = "";
$file_objects = "";

while ($entry = readdir(DIR)) {
	if ($entry =~ /\.con$/i) {
		if ($entry =~ /objects\.con/i  &&  $file_objects eq "") {
			$file_objects = $entry;
		} elsif ($entry =~ /Geometries\.con/i  &&  $file_geo eq "") {
			$file_geo = $entry;
		} else {
			push(@filelist, $entry);
		}
	}
}

if ($file_objects ne "") { unshift(@filelist, $file_objects); }
if ($file_geo ne "") 	 { unshift(@filelist, $file_geo); }


### main  
foreach $filename ( @filelist) {
	process_file($path . "\\" . $filename);
}

dump_mem() if ($DEBUG >= 2);
write_ccon();


### close
die "\n- DONE\n";


#------------------------------------------------------------

sub write_ccon() {
	print "\n- writing compiled con file: $file_ccon\n\n";

	open (OUT, ">$file_ccon");
	
	proc_object($head_object, "0/0/0;0/0/0");

	print OUT "\n";		### extra newline since maxscript's line input will only pull a string if a newline is present
	close (OUT);
}

sub proc_object() {
	my ($current_object, $pos) = @_;

	my $total_templates;
	my $ct;
	
	my $type = "";
	my $special = "";

	my $obj2;
	my $pos2;

	$type = $obj{$current_object}->{'type'};
	if ($type eq "") {
		$type = "ExternalDef";
	}

	if (exists $obj_special{$current_object}) {
		$special = $obj_special{$current_object};
	}


	print "-- object: $current_object $pos $special\n"  if ($DEBUG >= 2);
	print OUT  $type . " __" . $current_object ." $pos $special\n";

	$total_templates = $#{$obj_template{$current_object}};
	if ($total_templates >= 0) {	
		for ($ct = 0; $ct <= $total_templates; $ct++) {
			($obj2, $pos2) = split(/ /, $obj_template{$current_object}[$ct]);
			
			print "--- template: $obj2 -- $pos2\n" if ($DEBUG >= 2);
			proc_object($obj2, add_pos($pos, $pos2));
		}
	}

}

### add position and rotation settings
sub add_pos() {
	my ($d1, $d2) =@_;
	my $product;

	my ($pos1, $rot1);
	my ($pos2, $rot2);

	($pos1, $rot1) = split(/;/, $d1);
	($pos2, $rot2) = split(/;/, $d2);

	my @Apos1 = split(/\//, $pos1);
	my @Apos2 = split(/\//, $pos2);
	my @Arot1 = split(/\//, $rot1);
	my @Arot2 = split(/\//, $rot2);


	$product = 
			($Apos1[0] + $Apos2[0]) . "/" .
			($Apos1[1] + $Apos2[1]) . "/" .
			($Apos1[2] + $Apos2[2]) .
			";" .
			($Arot1[0] + $Arot2[0]) . "/" .
			($Arot1[1] + $Arot2[1]) . "/" .
			($Arot1[2] + $Arot2[2]);


	print "--- $d1 + $d2 = $product\n" if ($DEBUG >= 2);

	return $product;
}


sub dump_mem() {

  print "\nDumping Memory";

  foreach $con_item ( sort keys %obj) {
	### $temp = $obj{$con_item};
	print "\n-- $obj{$con_item}->{'name'};" .
                "$obj{$con_item}->{'pos'};" . 
                "$obj{$con_item}->{'rot'};" . 
	        "$obj{$con_item}->{'type'}" . 
		"\n";
	
	if (exists $obj_special{$con_item}) {
		print "--- Special: $obj_special{$con_item}\n";
	}

	$total_templates = $#{$obj_template{$con_item}};
	if ($total_templates >= 0) {	
		for ($ct = 0; $ct <= $total_templates; $ct++) {
			print "--- $obj_template{$con_item}[$ct]\n";
		}
	}
  }
}



sub process_file() {

  my ($file_con) = @_;

  $current_template = "";
  $current_special = "";
  $current_position = "0/0/0";
  $current_rotation = "0/0/0";

  $flag_rem = 0;

  print "- file: $file_con\n";

  open (IN, $file_con);

  while ($line = <IN>) {

	if ($line =~ /^rem/i) {

	} elsif ($line =~ /^beginrem/i) {
		$flag_rem = 1;

	} elsif ($line =~ /^endrem/i) {
		$flag_rem = 0;

	} elsif (($flag_rem == 0) && (
		$line =~ /ObjectTemplate\.create /i || 
		$line =~ /GeometryTemplate\.create /i ||
		$line =~ /\.addTemplate/i ||
		$line =~ /\.setPosition/i ||
		$line =~ /\.setRotation/i ||
		$line =~ /\.geometry/i ||
		$line =~ /\.file/i ||
		$line =~ /\.setEntryRadius/i 
		)) {
		
		chop ($line);
		@dd = split(/ +/, $line);

		if ($line =~ /ObjectTemplate.create/i) {

			if ($current_template ne "") {
				### write the last template
				print "- template  : $current_template\n" if ($DEBUG >= 2);
				$obj_template{$current_object}[$child_ct++] = "$current_template $current_position;$current_rotation";
			}
			if ($current_special ne "") {
				### write the last special
				print "- special  : $current_special\n" if ($DEBUG >= 2);
				$obj_special{$current_object} = "$current_special";
			}

		
			print "$line\n" if ($DEBUG >= 2);
	
			$child_ct = 0;
			$current_object = $dd[2];
			$current_template = "";
			$current_special = "";

			if ($head_object eq "") {
				$head_object = $current_object;
			}

			print "- new object: $current_object\n" if ($DEBUG >= 2);

			$obj{$current_object} = new CCon($current_object,
						"0/0/0",
						"0/0/0",
						$dd[1]
						);
		} else {
			print "$line\n" if ($DEBUG >= 2);
		}

		if ($line =~ /GeometryTemplate.create/i) {
			$current_geometry = $dd[2];
		}
	
		if ($line =~ /.addTemplate/i) {
			if ($current_template ne "") {			
				print "- template  : $current_template\n" if ($DEBUG >= 2);
				$obj_template{$current_object}[$child_ct++] = "$current_template $current_position;$current_rotation";
			}

			$current_template = $dd[1];
			$current_position = "0/0/0";
			$current_rotation = "0/0/0";
		}		

		if ($line =~ /.setPosition/i) {
			$current_position = $dd[1];
		}		

		if ($line =~ /.setRotation/i) {
			$current_rotation = $dd[1];
		}		

		if ($line =~ /.setEntryRadius/i) {
			$current_special = $dd[1];
		}

		### geometry stuff
		
		# from geometries.con file
		if ($line =~ /.file/i) {
			$mesh_geometry{uc($current_geometry)} = $dd[1];
		}


		# from objects.con file
		if ($line =~ /.geometry/i) {
			### $current_special = "$dd[1] = " . $mesh_geometry{uc($dd[1])};
			$current_special = $mesh_geometry{uc($dd[1])};
		}

	}

	
  }

	### write last entries
			if ($current_template ne "") {
				### write the last template
				print "- template  : $current_template\n" if ($DEBUG >= 2);
				$obj_template{$current_object}[$child_ct++] = "$current_template $current_position;$current_rotation";
			}
			if ($current_special ne "") {
				### write the last special
				print "- special  : $current_special\n" if ($DEBUG >= 2);
				$obj_special{$current_object} = "$current_special";
			}


  close (IN);
}


